﻿using System.Globalization;

namespace _02_ClassProperties.Demos.Bilgisayarlar
{
    public class BilgisayarDemo
    {
        public static void Calistir()
        {
            CultureInfo cultureInfo = new CultureInfo("tr");
            string dateFormat = "dd.MM.yyyy";
            Bilgisayar bilgisayar = new Bilgisayar()
            {
                Id = 1,
                Marka = "ASUS",
                Model = "ROG",
                Tipi = BilgisayarTipi.Dizüstü,
                GHz = 3.33,
                Hafiza = 32,
                EkranBoyutu = 27,
                SuSogutmaliMi = true,
                UretimTarihi = new DateTime(2020, 5, 19)
            };
            Console.WriteLine("*** Bilgisayar Bilgileri ***");
            Console.WriteLine("Id: " + bilgisayar.Id);
            Console.WriteLine("Marka: " + bilgisayar.Marka);
            Console.WriteLine("Model: " + bilgisayar.Model);
            Console.WriteLine("Tipi: " + bilgisayar.Tipi + " (" + (int)bilgisayar.Tipi + ")");
            Console.WriteLine("GHz: " + bilgisayar.GHz.ToString(cultureInfo));
            Console.WriteLine("Hafıza: " + bilgisayar.Hafiza + " Gb");
            Console.WriteLine("Ekran: " + bilgisayar.EkranBoyutu.ToString(cultureInfo) + " İnç");
            Console.WriteLine("Su Soğutuma: " + (bilgisayar.SuSogutmaliMi ? "Var" : "Yok"));
            Console.WriteLine("Üretim Tarihi: " + bilgisayar.UretimTarihi.ToString(dateFormat));
        }
    }
}
