﻿namespace _04_Constructors.Demos.ZamanIslemleri
{
    public class TimeOperationsDemo
    {
        public static void Calistir()
        {
            OrnekCalistir();
            Console.WriteLine();
            TestCalistir();
        }

        /// <summary>
        /// 10000 saniye süresi ve 21:21:21 zamanı için örnek methodu.
        /// </summary>
        public static void OrnekCalistir()
        {
            TimeOperations timeOperations;
            string time;
            int duration;

            timeOperations = new TimeOperations(10000);
            time = timeOperations.CalculateTime();
            Console.WriteLine($"\nTime: {time}");

            timeOperations = new TimeOperations("21:21:21");
            duration = timeOperations.CalculateDuration();
            Console.WriteLine($"Duration in seconds: {duration}");
        }

        /// <summary>
        /// 5000 farklı süre için test methodu.
        /// </summary>
        public static void TestCalistir()
        {
            TimeOperations timeOperations;
            string time;
            int duration;

            bool error = false;

            for (int d = 1; d <= 5000 && !error; d++) // d: duration in seconds
            {
                timeOperations = new TimeOperations(d);
                time = timeOperations.CalculateTime();
                Console.WriteLine("Time: " + time + ", Duration: " + d + " seconds");
                timeOperations = new TimeOperations(time);
                duration = timeOperations.CalculateDuration();
                if (d != duration)
                {
                    error = true;
                }
            }

            if (error)
                Console.WriteLine("Calculation error!");
            else
                Console.WriteLine("No calculation errors.");
        }
    }
}
