﻿using System.Globalization;

namespace _04_StaticClassesAndMethods
{
    /// <summary>
    /// String tipindeki veriler üzerinden işlemler gerçekleştirilebilen utility sınıfı.
    /// </summary>
    static class StringUtil
    {
        /// <summary>
        /// value ve default olarak true atanmış trim parametreleri üzerinden gönderilen string tipindeki value'nun null, "" veya " "
        /// değere sahip olup olmadığını kontrol eden method.
        /// </summary>
        /// <param name="value"></param>
        /// <param name="trim"></param>
        /// <returns>bool</returns>
        public static bool IsEmpty(string value, bool trim) // boş mu
        {
            //if (value == null) // 1. yöntem
            if (value is null) // 2. yöntem
                return true;

            if (trim) // eğer trim true ise
            {
                //if (value.Trim().Equals("") // 1. yöntem
                //if (value.Trim().Equals(string.Empty) // 2. yöntem
                //if (value.Trim() == "") // 3. yöntem
                if (value.Trim() == string.Empty) // 4. yöntem
                    return true;
            }
            else // eğer trim false ise
            {
                if (value == string.Empty)
                    return true;
            }
            return false;
        }

        /// <summary>
        /// string tipinin (class) IsNullOrWhiteSpace methodu ile bir string değerin null, trim'lenmiş değerinin de
        /// empty (içinde hiç bir karakter olmayan string değer) olup olmadığı kolaylıkla kontrol edilebilir.
        /// IsNullOrEmpty methodu ise trim'leme işlemi yapmadan bu kontrolü gerçekleştirir.
        /// </summary>
        /// <param name="value"></param>
        /// <returns>bool</returns>
        public static bool IsEmpty(string value) => string.IsNullOrWhiteSpace(value);



        /// <summary>
        /// value ve default olarak tr-TR atanmış culture (bölgesel ayar) input parametreleri üzerinden gönderilen string tipindeki value'nun
        /// sayısal olup olmadığını kontrol eden, ve number output parametresi üzerinden double dönüştürme işlemi başarılıysa 
        /// number output parametresini de dönen method.
        /// </summary>
        /// <param name="value"></param>
        /// <param name="culture"></param>
        /// <returns>bool</returns>
        public static bool IsNumeric(string value, out double number, string culture = "tr-TR") // sayısal mı
        {
            // TryParse parametreleri sırasıyla:
            // value: string değer,
            // NumberStyles.Number: dönüştürülmeye çalışılacak sayı stili,
            // new CultureInfo(culture): culture parametresine göre bölgesel ayar,
            // out number: TryParse methodu içerisinde dönüştürme işlemi başarılıysa dönüştürülen sayı olarak güncellenecek number referansı (adresi)
            return double.TryParse(value, NumberStyles.Number, new CultureInfo(culture), out number);
        }
    }
}
