﻿using _07_Interfaces.Demos.Sekiller.Bases;

namespace _07_Interfaces.Demos.Sekiller
{
    /// <summary>
    /// IKoseliSekil interface'ini implemente eden class.
    /// </summary>
    class Dikucgen : IKoseliSekil // Dikucgen bir IKoseliSekil'dir şeklinde de okunabilir
    {
        public double Genislik { get; set; } // özellik implementasyonu
        public double Yukseklik { get; set; } // özellik implementasyonu

        public double AlanHesapla() // method implementasyonu
        {
            return Genislik * Yukseklik / 2;
        }

        public double CevreHesapla() // method implementasyonu
        {
            double hipotenus = Math.Sqrt(Math.Pow(Genislik, 2) + Math.Pow(Yukseklik, 2)); // method için local değişken
            return hipotenus + Genislik + Yukseklik;
        }
    }
}
