﻿namespace _08_InterfaceSegregation._2_Fabrika.YanlisKullanim
{
    public class YanlisKullanimDemo
    {
        public static void Calistir()
        {
            ICalisan calisan = new Calisan(); // ICalisan tipindeki calisan referans değişkeni Calisan tipindeki objeyi refere ediyor

            calisan.YemekYe(); // konsola "Çalışan yemek yiyor." yazdırır

            calisan.Calis(); // konsola "Çalışan çalışıyor." yazdırır

            calisan.MaasAl(); // konsola "Çalışan maaş alıyor." yazdırır

            Console.WriteLine();



            Yonetici yonetici = new Yonetici();  // ICalisan yonetici = new Yoneitici(); de yazılabilir

            yonetici.YemekYe(); // konsola "Yönetici yemek yiyor." yazdırır

            yonetici.Calis(); // konsola "Yönetici çalışıyor." yazdırır

            yonetici.MaasAl(); // konsola "Yönetici maaş alıyor." yazdırır

            Console.WriteLine();



            ICalisan robot = new Robot(); // Robot robot = new Robot(); da yazılabilir

            robot.YemekYe(); // konsola bir şey yazdırmaz çünkü ilgili sınıfta methodun içi boş,
                             // içi boş olan methodlar yanlışlıkla çağrılıp sanki bir iş yapacakları sanılabilir, yanlış

            robot.Calis(); // konsola "Robot çalışıyor." yazdırır

            robot.MaasAl(); // konsola bir şey yazdırmaz çünkü ilgili sınıfta methodun içi boş,
                            // içi boş olan methodlar yanlışlıkla çağrılıp sanki bir iş yapacakları sanılabilir, yanlış
        }
    }



    /// <summary>
    /// Bir fabrikada çalışanlar için base interface.
    /// </summary>
    interface ICalisan
    {
        void Calis();
        void YemekYe();
        void MaasAl();
    }

    class Calisan : ICalisan // Calisan bir ICalisan'dır şeklinde de okunabilir,
                                    // Calisan için ICalisan'daki tüm method tanımlarını
                                    // dolu bir şekilde implemente edebiliyoruz
    {
        public void Calis()
        {
            Console.WriteLine("Çalışan çalışıyor.");
        }

        public void MaasAl()
        {
            Console.WriteLine("Çalışan maaş alıyor.");
        }

        public void YemekYe()
        {
            Console.WriteLine("Çalışan yemek yiyor.");
        }
    }

    class Yonetici : ICalisan // Yonetici bir ICalisan'dır şeklinde de okunabilir,
                                     // Yonetici için ICalisan'daki tüm method tanımlarını
                                     // dolu bir şekilde implemente edebiliyoruz
    {
        public void Calis()
        {
            Console.WriteLine("Yönetici çalışıyor.");
        }

        public void MaasAl()
        {
            Console.WriteLine("Yönetici maaş alıyor.");
        }

        public void YemekYe()
        {
            Console.WriteLine("Yönetici yemek yiyor.");
        }
    }

    class Robot : ICalisan // interface'deki tüm method tanımlarını dolu bir şekilde implemente edemediğimiz için
                                  // Interface Segregation prensibine aykırı ve yanlıştır
    {
        public void Calis()
        {
            Console.WriteLine("Robot çalışıyor.");
        }

        public void MaasAl() // Robot maaş almadığı için methodun içini dolduramayız
        {

        }

        public void YemekYe() // Robot yemek yemediği için methodun içini dolduramayız
        {

        }
    }
}
