﻿using _09_Inheritance.Demos.Elektronik;
using _09_Inheritance.Demos.Sekiller;

namespace _09_Inheritance
{
    internal class Program
    {
        // Inheritance (kalıtım veya miras), class (sınıf) hiyerarşi yapısında üstteki tek bir class üzerinden alttaki bir veya daha fazla class'a
        // field (alan), property (özellik) veya behavior'ların (davranış) aktarılmasını sağlayarak alttaki class'ların kendi field, property
        // veya behavior'ları üzerinden üstteki class yapısıyla birlikte genişletilmesini (extend) sağlar.
        // Dolayısıyla üstteki base (temel) veya parent class yapısı üzerinden aşağıdaki sub veya child class yapılarına
        // yeni alan, özellik veya davranışlar kazandırılmış olur.
        // Kalıtımda amaçlardan biri birden çok class'ta bulunacak ortak alan, özellik veya davranışları bir üst class'ta
        // oluşturarak aşağıdaki birden çok class'ta kod tekrarının önüne geçmektir.
        // C# programlama dilinde tüm class'ların en üstteki base veya parent class'ı Object class'ıdır, yani tüm nesneler default (varsayılan)
        // olarak object tipindeki nesneden türer.
        // Inheritance class'lar arasında is-a relationship kurar. Örneğin araba (sub class) bir araçtır (base class) veya
        // kare (sub class) bir şekildir (base class).



        static void Main(string[] args)
        {
            #region Futbol Takımları
            // FutbolTakimi tipindeki futbolTakimi1 referans değişkeni üzerinden FutbolTakimi tipinde obje initialize edilmesi (oluşturulması)
            FutbolTakimi futbolTakimi1 = new FutbolTakimi() 
            {
                Adi = "Fenerbahçe", // Takim base class'ından miras alınan özellik
                KurulusYili = 1907, // Takim base class'ından miras alınan özellik
                Sehir = "İstanbul", // Takim base class'ından miras alınan özellik

                TeknikDirektorAdi = "Jorge Jesus", // FutbolTakimi class'ı özelliği
                KaleciAdi = "Altay Bayındır", // FutbolTakimi class'ı özelliği
                DefansOyuncuAdlari = "Serdar Aziz, Gustavo Henrique, Attila Szalai, Ferdi Kadioglu", // FutbolTakimi class'ı özelliği
                OrtaSahaOyuncuAdlari = "Bright Osavi-Samuel, Miguel Crespo, Willian Arao", // FutbolTakimi class'ı özelliği
                ForvetOyuncuAdlari = "Diego Rossi, Joshua King, Michy Batshuayi", // FutbolTakimi class'ı özelliği
                OyunSistemi = "4-3-3" // FutbolTakimi class'ı özelliği
            };

            Console.WriteLine(futbolTakimi1.BilgiGetir()); // Takim base class'ından miras alınan davranış

            Console.WriteLine(futbolTakimi1.KadroGetir()); // FutbolTakimi class'ı davranışı

            Console.WriteLine("Oyun Sistemi: " + futbolTakimi1.OyunSistemi); // FutbolTakimi class'ı özelliği

            Console.WriteLine("Şehir: " + futbolTakimi1.Sehir); // Takim base class'ından miras alınan özellik

            // hem referans değişkeninin hem de oluşturulan objenin tipleri aynı olduğu için obje üzerinden tüm alan, özellik veya davranışlara ulaşılabilir
            
            Console.WriteLine();



            // Takim tipindeki takim2 referans değişkeni üzerinden FutbolTakimi tipinde obje initialize edilmesi (oluşturulması)
            Takim takim2 = new FutbolTakimi()
            {
                Adi = "Galatasaray", // Takim base class'ından miras alınan özellik
                KurulusYili = 1905, // Takim base class'ından miras alınan özellik
                Sehir = "İstanbul", // Takim base class'ından miras alınan özellik

                TeknikDirektorAdi = "Okan Buruk", // FutbolTakimi class'ı özelliği
                KaleciAdi = "Fernando Muslera", // FutbolTakimi class'ı özelliği
                DefansOyuncuAdlari = "Leo Dubois, Abdulkerim Bardakçı, Victor Nelsson, Sacha Boey", // FutbolTakimi class'ı özelliği
                OrtaSahaOyuncuAdlari = "Berkan Kutlu, Sergio Oliveira, Milot Rashica, Barış Alper Yılmaz", // FutbolTakimi class'ı özelliği
                ForvetOyuncuAdlari = "Muhammed Kerem Aktürkoğlu, Dries Mertens", // FutbolTakimi class'ı özelliği
                OyunSistemi = "4-4-2" // FutbolTakimi class'ı özelliği
            };

            Console.WriteLine(takim2.BilgiGetir()); // Takim base class'ından miras alınan davranış

            //Console.WriteLine(takim2.KadroGetir()); // takim2 referans değişkeni üzerinden KadroGetir methoduna ulaşılamaz

            // referans değişkeninin tipi Takim olduğundan takim2 referans değişkeni üzerinden sadece Takim içerisindeki alan, özellik veya davranışlara ulaşılabilir,
            // eğer FutbolTakimi içerisindeki alan, özellik veya davranışlara ulaşılmak isteniyorsa casting (birbirlerine uyumlu tip dönüşümü) yapılmalıdır.

            //FutbolTakimi futbolTakimi2 = (FutbolTakimi)takim2; // casting 1. yöntem
            FutbolTakimi futbolTakimi2 = takim2 as FutbolTakimi; // casting 2. yöntem

            Console.WriteLine(futbolTakimi2.KadroGetir()); // casting işleminden sonra futbolTakimi2 referans değişkeni üzerinden
                                                           // KadroGetir methoduna ulaşılabilir

            //Console.WriteLine("Oyun Sistemi: " + takim2.OyunSistemi); // takim2 referans değişkeni üzerinden OyunSistemi özelliğine ulaşılamaz
            Console.WriteLine("Oyun Sistemi: " + futbolTakimi2.OyunSistemi); // casting işleminden sonra futbolTakimi2 referans değişkeni üzerinden
                                                                             // OyunSistemi özelliğine ulaşılabilir

            Console.WriteLine("Şehir: " + futbolTakimi2.Sehir); // Takim base class'ından miras alınan özellik

            Console.WriteLine();
            #endregion



            #region Basketbol Takımları
            // BasketbolTakimi tipindeki basketbolTakimi3 referans değişkeni üzerinden BasketbolTakimi tipinde obje initialize edilmesi (oluşturulması)
            BasketbolTakimi basketbolTakimi3 = new BasketbolTakimi();

            basketbolTakimi3.Adi = "Beşiktaş"; // Takim base class'ından miras alınan özellik
            basketbolTakimi3.KurulusYili = 1903; // Takim base class'ından miras alınan özellik
            basketbolTakimi3.Sehir = "İstanbul"; // Takim base class'ından miras alınan özellik

            basketbolTakimi3.BasantrenorAdi = "Igor Milicic"; // BasketbolTakimi class'ı özelliği
            basketbolTakimi3.GeriSahaOyuncuAdlari = "Yağız Aksu, Allerik Freeman"; // BasketbolTakimi class'ı özelliği
            basketbolTakimi3.OnSahaOyuncuAdlari = "David McCormack, Okben Ulubay, Kerem Konan"; // BasketbolTakimi class'ı özelliği

            Console.WriteLine(basketbolTakimi3.BilgiGetir()); // Takim base class'ından miras alınan davranış

            Console.WriteLine($"Geri Saha: {basketbolTakimi3.GeriSahaOyuncuAdlari}"); // BasketbolTakimi class'ı özelliği
            Console.WriteLine($"Ön Saha: {basketbolTakimi3.OnSahaOyuncuAdlari}"); // BasketbolTakimi class'ı özelliği

            Console.WriteLine($"Başantrenör: {basketbolTakimi3.BasantrenorAdi}"); // BasketbolTakimi class'ı özelliği

            Console.WriteLine($"Şehir: {basketbolTakimi3.Sehir}"); // Takim base class'ından miras alınan özellik

            // hem referans değişkeninin hem de oluşturulan objenin tipleri aynı olduğu için obje üzerinden tüm alan, özellik veya davranışlara ulaşılabilir

            Console.WriteLine();



            // Takim tipindeki takim4 referans değişkeni üzerinden BasketbolTakimi tipinde obje initialize edilmesi (oluşturulması)
            Takim takim4 = new BasketbolTakimi();

            takim4.Adi = "Anadolu Efes"; // Takim base class'ı özelliği
            takim4.KurulusYili = 1976;  // Takim base class'ı özelliği
            takim4.Sehir = "İstanbul";  // Takim base class'ı özelliği

            Console.WriteLine(takim4.BilgiGetir() + "\nŞehir: " + takim4.Sehir); // Takim base class'ı davranışı ve özelliği

            Console.WriteLine();

            // referans değişkeninin tipi Takim olduğundan obje üzerinden sadece Takim class'ı içerisindeki alan, özellik veya davranışlara ulaşılabilir,
            // Takim takim4 = new Takim(); olarak obje initialization'ı da yapsak ki Takim concrete yani somut class olduğundan yapılabilir aynı sonucu alacaktık,
            // ancak bizim istediğimiz sonuç objeleri futbol veya basketbol takım objeleri olduğundan yukarıdaki kullanım pek uygun değildir
            #endregion



            #region Elektronik Demo
            ElektronikDemo.Calistir();
            #endregion



            #region Şekiller Demo
            SekillerDemo.Calistir();
            #endregion
        }
    }
}