﻿using _11_AbstractClasses._2_Dersler.Bases;

namespace _11_AbstractClasses._2_Dersler
{
    class YazilimDersi : DersBase // YazilimDersi bir DersBase'dir (is-a relationship).
                                  // DersBase içerisindeki KodGetir soyut method tanımı ezilerek implemente edilmelidir.
                                  // MaksimumNotGetir ve DersNotuHesapla sanal methodları ise isteğe göre
                                  // ezilerek davranışları değiştirilebilir.
    {
        #region Properties
        /// <summary>
        /// Yazılım dersinin son sınav notu özelliği.
        /// </summary>
        public double SonSinavNotu { get; set; }
        #endregion



        #region Behaviors
        /// <summary>
        /// Yazılım dersleri için YZL ön eki üzerinden atanan Id ile ders kodunu döner.
        /// </summary>
        /// <returns>string</returns>
        public override string KodGetir() => "YZL-" + Id;



        // Yazılım dersleri için maksimum not 100 olacağından MaksimumNotGetir() methodunu ezmeyip base sınıfındakini kullanacağız.
        // Aşağıdaki şekilde de method ezilip base sınıfındaki method çağrılabilir ancak bunu yapmaya gerek yoktur çünkü
        // iki işlem sonucunda da base sınıfındaki methodu kullanmış oluyoruz.
        //public override byte MaksimumNotGetir() => base.MaksimumNotGetir();



        /// <summary>
        /// 1. ve 2. sınav not ağırlıkları %20, son sınav not ağrılığı ise %60 olacak şekilde ders notunu döner.
        /// </summary>
        /// <returns>double</returns>
        public override double DersNotuHesapla() => Sinav1Notu * 0.2 + Sinav2Notu * 0.2 + SonSinavNotu * 0.6;
        #endregion
    }
}
