﻿using _11_AbstractClasses.Demos.Sekiller.Bases;

namespace _11_AbstractClasses.Demos.Sekiller
{
    /// <summary>
    /// KoseliSekilBase abstract (soyut) class'ından miras alan concrete (somut) class.
    /// </summary>
    class Dikucgen : KoseliSekilBase // Dikucgen bir KoseliSekilBase'dir şeklinde de okunabilir
    {
        public override double AlanHesapla() // methodun ezilerek implementasyonu
        {
            return Genislik * Yukseklik / 2;
        }

        public override double CevreHesapla() // methodun ezilerek implementasyonu
        {
            double hipotenus = Math.Sqrt(Math.Pow(Genislik, 2) + Math.Pow(Yukseklik, 2)); // method için local değişken
            return hipotenus + Genislik + Yukseklik;
        }
    }
}
