﻿using _12_InterfacesVsAbstractClasses._2_AbstractClassOrnegi.Bases;
using System.Text;

namespace _12_InterfacesVsAbstractClasses._2_AbstractClassOrnegi
{
    class MetinselOgrenciDosya : OgrenciDosyaBase // MetinselOgrenciDosya somut (concrete) sınıfı OgrenciDosyaBase soyut (abstract) sınıfından miras alır (inherit eder),
                                                  // MetinselOgrenciDosya bir OgrenciDosyaBase'dir şeklinde de okunabilir
    {
        #region Methodlar
        // OgrenciDosyaBase soyut sınıfından miras aldığımızdan soyut method tanımı üzerinden ezmemiz (override) için method oluşturuldu
        public override string OgrencileriGetir(bool sayiEkle)
        {
            string ogrenciler = ""; // dosyadan okuyacağımız öğrenci bilgilerini atayacağımız ve ilk olarak da içinde hiç bir karakter olmayan string değeri ataması yaptığımız değişken

            if (sayiEkle) // eğer sayiEkle true ise dosyadan okuduğumuz öğrenci bilgilerinin başına artacak şekilde sayı ekleyeceğiz
            {
                string[] ogrenciDizisi = File.ReadAllLines(DosyaYolu, Encoding.UTF8); // önce dizi olarak öğrenci bilgilerini alıyoruz,
                                                                                      // File class'ının ReadAllLines methodu dosya içeriğindeki her bir satır üzerinden string[] döner,
                                                                                      // Encoding.UTF8 parametresi yazılmasa da olur ancak eğer metinsel dosya içeriğinde Türkçe karakterler
                                                                                      // (utf-8 karakter kümesi) varsa karakterlerde sorun yaşanmaması için kullanılması iyi olur

                for (int i = 0; i < ogrenciDizisi.Length; i++) // sonra dizideki her bir öğrenci bilgisini turlayarak öğrenci bilgisi başına birer birer artacak şekilde sayı ekliyoruz
                {
                    ogrenciler += i + 1 + ") " + ogrenciDizisi[i] + "\n";
                }

                ogrenciler = ogrenciler.TrimEnd('\n'); // döngü sonucunda oluşan ogrenciler'deki en son \n (new line) escape character'ini (escape sequence) temizliyoruz
            }
            else // eğer sayiEkle false ise dosyadan okuduğumuz öğrenci bilgilerini ekstra hiç bir işlem yapmadan döneceğiz
            {
                ogrenciler = File.ReadAllText(DosyaYolu, Encoding.UTF8); // File class'ının ReadAllText methodu dosya içeriğini string olarak döner
            }

            return ogrenciler; // öğrenci bilgilerini dönüyoruz
        }



        // OgrenciDosyaBase soyut sınıfından miras aldığımızdan soyut method tanımı üzerinden ezmemiz (override) için method oluşturuldu
        public override void OgrenciEkle(string ogrenci) 
        {
            File.AppendAllText(DosyaYolu, "\n" + ogrenci, Encoding.UTF8); // File class'ının AppentAllText methodu gönderilen string tipindeki veriyi dosyanın sonuna ekler,
                                                                          // eğer WriteAllText methodu kullanılsaydı gönderilen veri mevcut verinin üzerine yazılacaktı (overwrite)
                                                                          // dolayısıyla mevcut veri kaybedilecekti
        }
        #endregion
    }
}
