﻿using _13_Polymorphism.Enums;

namespace _13_Polymorphism.Models.Bases
{
    /// <summary>
    /// PcOyunu ve PlaystationOyunu class'ları için ortak özellikleri içeren base (parent) class.
    /// </summary>
    class VideoOyunu // eğer VideoOyunu tipinde obje initialize edilmeyecekse (oluşturulmayacaksa) sonuna Base eklenerek abstract da tanımlanabilir,
                     // bu uygulamada VideoOyunu tipinde obje oluşturup kullanacağız
    {
        #region Properties
        public string Adi { get; set; }

        public DateTime CikisTarihi { get; set; }

        public string[] Turleri { get; set; }

        public OyuncuSayisi OyuncuSayisi { get; set; } // tek oyunculu, çok oyunculu veya ikisi de,
                                                       // soldaki OyuncuSayisi tipi (enum), sağdaki OyuncuSayisi ise özellik adıdır

        public string Yapimcisi { get; set; }



        // 1. yöntem:
        //public string TurleriGosterim // sadece Turleri dizisine göre gösterim için kullanılacak, değer atanamayacak (set edilemeyecek)
        //{
        //    get
        //    {
        //        // oyun türlerini Turleri dizisinde (koleksiyon) döngüyle turlayarak bu getter (readonly: sadece okunur)
        //        // içerisindeki değişkene , ile ayırarak concatenate ediyoruz (art arda ekleme):
        //        string turler = string.Empty; // string turler = "";

        //        if (Turleri is not null) // if (Turleri != null)
        //        {
        //            foreach (string turu in Turleri)
        //            {
        //                turler += turu + ", ";
        //            }

        //            // döngü bittikten sonra da en sondaki virgül ile boşluğu temizliyoruz:
        //            // 1. yöntem:
        //            //turler = turler.TrimEnd(',', ' ');
        //            // 2. yöntem:
        //            //turler = turler.TrimEnd(", ".ToCharArray());
        //            // 3. yöntem:
        //            if (!string.IsNullOrEmpty(turler))
        //                turler = turler.Substring(0, turler.Length - 2);
        //        }

        //        // oluşturduğumuz turler değişkenini dönüyoruz
        //        return turler;
        //    }
        //}
        // 2. yöntem:
        public string TurleriGosterim => string.Join(", ", Turleri);



        public string OyuncuSayisiGosterim // sadece OyuncuSayisi özelliğine göre gösterim için kullanılacak (readonly: sadece okunur), değer atanamayacak (set edilemeyecek)
        { 
            get
            {
                // OyuncuSayisi enum'ına göre tek oyunculu, çok oyunculu veya hem tek hem çok oyunculu değerini oyuncuSayisi değişkenine atıyoruz:
                string oyuncuSayisi;

                //oyuncuSayisi = videoOyunu.OyuncuSayisi.ToString(); // bu şekilde enum'daki değerlere karşılık isimlendirmeleri de kullanılabilir,
                                                                     // TekOyuncu, ÇokOyuncu veya HemTekHemÇokOyuncu şeklinde oyuncuSayisi atanacaktır

                // Flags attribute'u ile tanımlanmış enum'ların değerleri HasFlag methodu ile kontrol edilebilir
                oyuncuSayisi = OyuncuSayisi.HasFlag(OyuncuSayisi.TekOyuncu) && OyuncuSayisi.HasFlag(OyuncuSayisi.ÇokOyuncu) ? "Hem Tek Hem Çok"
                    : OyuncuSayisi.HasFlag(OyuncuSayisi.TekOyuncu) ? "Tek"
                    : "Çok";

                // daha sonra Oyunculu değerini oyuncuSayisi değişkeninin sonuna ekliyoruz:
                oyuncuSayisi += " Oyunculu";

                // oluşturduğumuz oyuncuSayisi değişkenini dönüyoruz
                return oyuncuSayisi;
            }
        }
        #endregion
    }
}
