﻿using _13_Polymorphism.Models.Bases;

namespace _13_Polymorphism.Models
{
    class PcOyunu : VideoOyunu // PcOyunu sub (child) class'ı VideoOyunu base (parent) class'ından miras alır,
                               // PcOyunu bir VideoOyunu'dur şeklinde de okunabilir (is-a relationship)
    {
        #region Properties
        /// <summary>
        /// Oyunun çalışabileceği işletim sistemleri.
        /// </summary>
        public string[] IsletimSistemleri { get; set; }

        /// <summary>
        /// Oyunun Steam'de olup olmaması.
        /// </summary>
        public bool SteamOyunuMu { get; set; }



        // 1. yöntem:
        //public string IsletimSistemleriGosterim // sadece IsletimSistemleri dizisine göre gösterim için kullanılacak, değer atanamayacak (set edilemeyecek)
        //{
        //    get
        //    {
        //        // işletim sistemlerini IsletimSistemleri dizisinde (koleksiyon) döngüyle turlayarak isletimSistemleri değişkenine
        //        // \n (new line) escape sequence'ı (escape character) ile ayırarak concatenate ediyoruz (art arda ekleme):
        //        string isletimSistemleri = string.Empty; // string isletimSistemleri = "";

        //        if (IsletimSistemleri is not null) // if (IsletimSistemleri != null)
        //        {
        //            foreach (var isletimSistemi in IsletimSistemleri)
        //            {
        //                isletimSistemleri += isletimSistemi + "\n";
        //            }

        //            // döngü bittikten sonra da en sondaki \n escape sequence'ını temizliyoruz:
        //            if (!string.IsNullOrEmpty(isletimSistemleri))
        //                isletimSistemleri = isletimSistemleri.Remove(isletimSistemleri.Length - 1);
        //        }

        //        // oluşturduğumuz isletimSistemleri değişkenini dönüyoruz
        //        return isletimSistemleri;
        //    }
        //}
        // 2. yöntem:
        public string IsletimSistemleriGosterim => string.Join("\n", IsletimSistemleri);



        public string SteamOyunuMuGosterim => SteamOyunuMu ? "Evet" : "Hayır"; // sadece getter (get methodu) için bu şekilde de yazılabilir,
                                                                               // sadece SteamOyunuMu özelliğine göre gösterim için kullanılacak (readonly: sadece okunur),
                                                                               // değer atanamayacak (set edilemeyecek)
        #endregion
    }
}
