﻿namespace _18_CollectionMethods.Demos._1_SayiTekillik
{
    public class SayiTekillikDemo
    {
        #region I) Sayı Tekillik Demo'yu Çalıştıran Method
        public void Calistir()
        {
            Console.WriteLine("\n*** Sayı Tekillik Demo ***");

            // Tekrarlamayan Sayılar Demo (Farklı test senaryoları)
            List<int> tekrarlamayanSayilar1 = new List<int>() { 1, 2, 3, 4, 5, 6, 7, 8, 9 };
            Console.Write("Sayılar: ");
            Yazdir(tekrarlamayanSayilar1);
            TekrarlayanSayilariYazdir(tekrarlamayanSayilar1);

            List<int> tekrarlamayanSayilar2 = new List<int>() { 9, 8, 7, 6, 5, 4, 3, 2, 1 };
            Console.Write("Sayılar: ");
            Yazdir(tekrarlamayanSayilar2);
            TekrarlayanSayilariYazdir(tekrarlamayanSayilar2);

            List<int> tekrarlamayanSayilar3 = new List<int>() { 3, 1, 5, 2, 4, 9, 6, 8, 7 };
            Console.Write("Sayılar: ");
            Yazdir(tekrarlamayanSayilar3);
            TekrarlayanSayilariYazdir(tekrarlamayanSayilar3);



            // Tekrarlayan Sayılar Demo (Farklı test senaryoları)
            List<int> tekrarlayanSayilar1 = new List<int>() { 1, 2, 2, 3, 3, 3, 4, 4, 5 };
            Console.Write("\nSayılar: ");
            Yazdir(tekrarlayanSayilar1);
            TekrarlayanSayilariYazdir(tekrarlayanSayilar1);

            List<int> tekrarlayanSayilar2 = new List<int>() { 5, 4, 4, 3, 3, 3, 2, 2, 1 };
            Console.Write("Sayılar: ");
            Yazdir(tekrarlayanSayilar2);
            TekrarlayanSayilariYazdir(tekrarlayanSayilar2);

            List<int> tekrarlayanSayilar3 = new List<int>() { 3, 1, 5, 2, 2, 4, 3, 4, 3 };
            Console.Write("Sayılar: ");
            Yazdir(tekrarlayanSayilar3);
            TekrarlayanSayilariYazdir(tekrarlayanSayilar3);
        }
        #endregion



        #region II) Sayı Tekillik Demo Davranışları
        /// <summary>
        /// Parametre olarak gönderilen sayılar listesi üzerinden tekrarlayan sayıları konsola yazdırır.
        /// </summary>
        /// <param name="sayilar"></param>
        private void TekrarlayanSayilariYazdir(List<int> sayilar)
        {
            // sayilar koleksiyonu üzerinden tekrarlayan sayıları ekleyeceğimiz koleksiyon
            List<int> tekrarlayanSayilar = new List<int>();

            // tekrarlayan sayı adedi için kullanacağımız local değişken
            int tekrarlayanSayiAdedi;

            for (int i = 0; i < sayilar.Count; i++) // dışarıdaki döngüde sayıları ilk elemanından itibaren turlamaya başlıyoruz
            {
                tekrarlayanSayiAdedi = 0; // sayılar koleksiyonunun her bir elemanı için tekrarlayan sayı adedini tekrar 0 olarak atıyoruz

                for (int j = i + 1; j < sayilar.Count; j++) // içerideki döngüde dışarıdaki döngü turundaki her bir eleman için
                                                            // bir sonraki eleman üzerinden turlamaya başlıyoruz
                {
                    if (sayilar[i] == sayilar[j]) // eğer eşitlik varsa tekrarlıyor demektir, tekrarlayan sayı adedini 1 arttırıyoruz
                    {
                        tekrarlayanSayiAdedi++;
                    }
                }
                if (tekrarlayanSayiAdedi > 0) // eğer tekrarlayan sayı adedi 0'dan büyükse tekrarlayan sayılar koleksiyonuna ekliyoruz
                {
                    tekrarlayanSayilar.Add(sayilar[i]);
                }
            }

            // yukarıdaki döngüler bittikten sonra elimizde çoklayan bir şekilde tekrarlayan sayı koleksiyonu olacağından
            // Distinct methodu ile çoklayanları teke düşürüp methodun dönüş tipi olan bir IEnumerable<int> tipinde değişkene atıyoruz,
            // IEnumerable bir interface'dir ve koleksiyon tipidir, dolayısıyla bazı koleksiyon method ve özellikleri kullanılabilir
            IEnumerable<int> tekilTekrarlayanSayilar = tekrarlayanSayilar.Distinct();

            int tekilTekrarlayanAdet = tekilTekrarlayanSayilar.Count(); // IEnumerable tipte bir koleksiyonun eleman sayısı
                                                                        // Count() methodu ile alınır

            if (tekilTekrarlayanAdet == 0)
            {
                Console.WriteLine("Sayılar içerisinde tekrarlayan sayı bulunmamaktadır.");
            }
            else
            {
                Console.Write("Sayılar içerisinde " + tekilTekrarlayanAdet + " adet tekrarlayan sayı bulunmaktadır: ");
                Yazdir(tekilTekrarlayanSayilar.ToList()); // IEnumerable tipte bir koleksiyon üzerinden ToList methodu
                                                          // ile List tipinde bir koleksiyon oluşturulabilir
            }
        }



        /// <summary>
        /// Parametre olarak gönderilen sayı listesinin elemanlarını virgül ile ayırarak konsola yazdırır.
        /// </summary>
        /// <param name="sayilar"></param>
        private void Yazdir(List<int> sayilar)
        {
            string sonuc = "";
            foreach (int sayi in sayilar)
            {
                sonuc += sayi + ", ";
            }
            sonuc = sonuc.Trim(',', ' ');
            Console.WriteLine(sonuc);
        }
        #endregion
    }
}
