﻿using _18_CollectionMethods;
using _18_CollectionMethods.Demos._1_SayiTekillik;
using _18_CollectionMethods.Demos._2_IsimBulma;
using _18_CollectionMethods.Demos._3_Organizasyonlar;

namespace _19_CollectionMethodsAndProperties
{
    internal class Program
    {
        static void Main(string[] args)
        {
            // Koleksiyon method ve özelliklerinin çoğu tüm koleksiyon tipleri için kullanılabilir.
            // string de karakter dizisi (koleksiyonu) olduğu için bazı method ve özellikler string için de kullanılabilir.



            #region I) Koleksiyon Method ve Özellikleri

            // Aşağıdaki Örnekler için Değişken Tanım ve Atamaları
            List<int> sayilar = new List<int>() // bir koleksiyonda bir veya daha fazla eleman olabilir veya hiç eleman olmayabilir
            {
                5, 2, 3, 4, 1, 5
            };

            List<Kopek> kopekler = new List<Kopek>()
            {
                new Kopek("Angel", "İrlanda Seteri", 15, false)
            };

            List<string> oyuncular; // aşağıda Şener Şen, Kemal Sunal ve Adile Naşit olarak oluşturlacak



            #region Count Özelliği Örnekleri
            // Count Özelliği Örnek 1: Count bir koleksiyondaki eleman sayısını döner.
            Console.WriteLine("1) Sayılar Koleksiyonu Eleman Sayısı (Count): " + sayilar.Count);



            // Count Özelliği Örnek 2
            Console.WriteLine("\n2) Köpekler Koleksiyonu Eleman Sayısı (Count): " + kopekler.Count);
            #endregion



            #region Add ve AddRange Method Örnekleri
            // Add Methodu Örnek 1
            sayilar.Add(7);
            sayilar.Add(6);

            Yazdir("3)", sayilar);



            // Add Methodu Örnek 2
            Kopek yeniKopek = new Kopek("Leo", "Sheltie", 8, true); // 1. yöntem: methoda parametre olarak daha önceden
                                                                    // new'lenmiş bir objenin referans değişkeni gönderilebilir
            kopekler.Add(yeniKopek);

            kopekler.Add(new Kopek("Luna", "Sheltie", 1, false)); // 2. yöntem: methoda parametre olarak
                                                                  // new'lenmiş bir obje gönderilebilir

            Yazdir("4)", kopekler);



            // AddRange Methodu Örnek 1
            List<int> yeniSayilar = new List<int>() // int[] yeniSayilar = new int[] olarak da array kullanılabilir
            {
                8,
                9
            };

            sayilar.AddRange(yeniSayilar); // 1. yöntem: methoda parametre olarak daha önceden new'lenmiş
                                           // bir koleksiyonun referans değişkeni gönderilebilir

            Yazdir("5)", sayilar);



            // AddRange Methodu Örnek 2
            kopekler.AddRange(new List<Kopek>() // 2. yöntem: methoda parametre olarak new'lenmiş bir koleksiyon gönderilebilir
            {
                new Kopek("Leo Jr.", "Sheltie", 1, true),
                new Kopek("Lassie", "Rough Collie", 3, false)
            });

            Yazdir("6)", kopekler);
            #endregion



            #region IEnumerable, ICollection ve IList Tip Örnekleri
            // List class'ı IEnumerable, ICollection ve IList interface'lerini implemente ettiğinden
            // IEnumerable, ICollection veya IList tipinde bir referans değişkeni üzerinden
            // Polymorphism'den faydalanılarak List tipinde bir obje initialize edilebilir (oluşturulabilir).
            // IEnumerable Örneği
            IEnumerable<string> oyuncuKoleksiyonu = new List<string>()
            {
                "Şener Şen", "Kemal Sunal", "Adile Naşit"
            };

            // İhtiyaç halinde IEnumerable, ICollection veya IList tipindeki bir referans değişkeni üzerinden
            // ToList methodu çağrılarak koleksiyon List tipine dönüştürülebilir.
            // IEnumerable, ICollection, IList veya List tipindeki bir referans değişkeni üzerinden
            // ToArray methodu ile de dizi dönüşümü gerçekleştirilebilir.
            oyuncular = oyuncuKoleksiyonu.ToList();

            Yazdir("7)", oyuncular);



            // ICollection Örneği
            ICollection<Kopek> kopekKoleksiyonu = new List<Kopek>()
            {
                new Kopek("Max", "Border Collie", 5, true),
                new Kopek("Snoopy", "Beagle", 7, true)
            };

            List<Kopek> kopekListesi = kopekKoleksiyonu.ToList();

            Yazdir("8)", kopekListesi, "Köpek Listesi");



            // Bir List objesinin elemanları başka bir listeye ToList methodu çağrılarak kopyalanabilir.
            List<Kopek> kopeklerKopya = kopekler.ToList();

            Yazdir("9)", kopeklerKopya, "Kopyalanmış Köpekler");



            // IList Örneği
            IList<int> sayiKoleksiyonu = new List<int>()
            {
                11, 22, 33, 44, 55
            };

            List<int> sayiListesi = sayiKoleksiyonu.ToList();

            Yazdir("10)", sayiListesi, "Sayı Listesi");
            #endregion



            #region Sort, Sum, Average, Minimum ve Maximum Method Örnekleri
            // Bir koleksiyonda Sort methodu kullanılarak primitive veri tipleri üzerinden (örneğin int, string, double, vb.)
            // artan sıralama yapılabilir.
            sayilar.Sort();

            Yazdir("11)", sayilar, "Sıralanmış Sayılar");



            // Sum methodu ile sayısal primitive tipte elemanlara sahip bir koleksiyonun elemanları toplanabilir.
            Console.WriteLine("12) Sayılar Koleksiyonu Elemanları Toplamı: " + sayilar.Sum());



            // Average methodu ile sayısal primitive tipte elemanlara sahip bir koleksiyonun elemanlarının ortalaması alınabilir.
            Console.WriteLine("13) Sayılar Koleksiyonu Elemanlarının Ortalaması: " + sayilar.Average());



            // Minimum ve Maximum methodları ile primitive tipte elemanlara sahip bir koleksiyonun
            // sırasıyla minimum ve maksimum elemanı dönülebilir.
            Console.WriteLine("14) Sayılar Koleksiyonu Minimum Elemanı: " + sayilar.Min());

            Console.WriteLine("15) Oyuncular Koleksiyonu Maksimum Elemanı: " + oyuncular.Max());
            #endregion



            #region IndexOf, LastIndexOf ve Contains Method Örnekleri
            // IndexOf methodu eğer parametre olarak gönderilen elemanı koleksiyonun ilk elemanından aramaya başlayıp
            // bulursa ilk bulunan elemanın index'ini, bulamazsa -1 döner. Büyük küçük harf duyarlıdır (Case sensitive).
            Console.WriteLine("\n16) Kemal Sunal oyuncusunun index'i: " + oyuncular.IndexOf("Kemal Sunal")); // IndexOf 1 döner

            Console.WriteLine("17) adile naşit oyuncusunun index'i: " + oyuncular.IndexOf("adile naşit")); // IndexOf -1 döner

            Console.WriteLine("18) Tom Cruise oyuncusunun index'i: " + oyuncular.IndexOf("Tom Cruise")); // IndexOf -1 döner

            Console.WriteLine("\n19) 5 sayısının index'i: " + sayilar.IndexOf(5)); // IndexOf 4 döner



            // LastIndexOf methodu eğer parametre olarak gönderilen elemanı koleksiyonun ilk elemanından aramaya başlayıp
            // bulursa son bulunan elemanın index'ini, bulamazsa -1 döner. Büyük küçük harf duyarlıdır.
            Console.WriteLine("20) 5 sayısının son index'i: " + sayilar.LastIndexOf(5)); // LastIndexOf 5 döner



            // Contains methodu eğer parametre olarak gönderilen elemanı koleksiyon içerisinde bulursa true,
            // bulamazsa false döner. Büyük küçük harf duyarlıdır.
            if (oyuncular.Contains("Şener Şen")) // Contains true döner
                Console.WriteLine("\n21) Şener Şen oyuncusu bulundu.");
            else
                Console.WriteLine("\n21) Şener Şen oyuncusu bulunamadı.");

            Console.WriteLine("22) " + (sayilar.Contains(-1) ? "-1 sayısı bulundu." : "-1 sayısı bulunamadı."));



            // IndexOf, LastIndexOf ve Contains methodları eğer parametre olarak new'lenmiş bir obje alırsa
            // listedeki elemanların referansları ile new'lenmiş objenin referansı farklı olduğundan bulamaz.
            if (kopekler.Contains(new Kopek("Leo Jr.", "Sheltie", 1, true))) // Contains false döner
                Console.WriteLine("\n23) Leo Jr. köpeği bulundu.");
            else
                Console.WriteLine("\n23) Leo Jr. köpeği bulunamadı.");



            // Ancak listedeki bir elemanın referansı parametre olarak IndexOf, LastIndexOf veya Contains
            // methodlarına gönderilirse o zaman method Contains için true,
            // IndexOf ve LastIndexOf için elemanın index'ini döner.
            Kopek kopeklerdekiEleman = kopekler[3];

            Console.WriteLine("\n24) Leo Jr. köpeğinin index'i: " + kopekler.IndexOf(kopeklerdekiEleman)); // IndexOf 3 döner
            #endregion



            #region Insert, Remove, RemoveAt ve Clear Method Örnekleri
            // Insert methodu ilk parametre olarak gönderilen index'e ikinci parametre olarak gönderilen elemanı ekler.
            oyuncular.Insert(1, "Münir Özkul"); // oyuncular'ın 1. index'ine Münir Özkul'u ekleyecek

            Yazdir("25)", oyuncular);



            Kopek eklenecekVeCikarilacakKopek = new Kopek("Sharky", "Sharkdog", 2, true);
            kopekler.Insert(0, eklenecekVeCikarilacakKopek); // kopekler'in en başına Sharky adlı köpeği ekleyecek

            Yazdir("26)", kopekler);



            // Remove methodu parametre olarak gönderilen elemanı eğer eleman referans tipse elemanın
            // bulduğu ilk referansı üzerinden, eleman değer tipse elemanın bulduğu ilk değeri üzerinden koleksiyondan çıkarır.
            kopekler.Remove(eklenecekVeCikarilacakKopek);

            Yazdir("27)", kopekler);



            sayilar.Remove(5);

            Yazdir("28)", sayilar);



            // RemoveAt methodu parametre olarak gönderilen index üzerinden elemanı koleksiyondan çıkarır.
            oyuncular.RemoveAt(oyuncular.Count - 1); // oyuncular'ın son elemanını çıkaracak

            Yazdir("29)", oyuncular);



            // Clear methodu bir koleksiyondaki tüm elemanları koleksiyondan çıkarır,
            // dolayısıyla koleksiyonun Count özelliği 0 döner.
            //sayilar.Clear();
            #endregion



            #region First, FirstOrDefault, Last ve LastOrDefault Method Örnekleri
            int ilkSayi, sonSayi;
            string ilkOyuncu, sonOyuncu;
            Kopek ilkKopek, sonKopek;

            // First methodu bir koleksiyondaki ilk elemanı bulursa döner, bulamazsa ki örneğin koleksiyonda eleman olmaması durumunda
            // beklenmedik hata (exception) fırlatır.
            ilkSayi = sayilar.First();
            Console.WriteLine($"\n30) First methodu sonucu ilk sayı: {ilkSayi}");

            // FirstOrDefault methodu bir koleksiyondaki ilk elemanı bulursa döner, bulamazsa varsayılan (default) bir değer döner,
            // koleksiyon elemanlarının tipi sayısal tip ise 0 referans tip ise null döner.
            ilkOyuncu = oyuncular.FirstOrDefault();
            Console.WriteLine($"31) FirstOrDefault methodu sonucu ilk oyuncu: {ilkOyuncu}");

            // Last methodu bir koleksiyondaki son elemanı bulursa döner, bulamazsa ki örneğin koleksiyonda eleman olmaması durumunda
            // beklenmedik hata (exception) fırlatır.
            sonOyuncu = oyuncular.Last();
            Console.WriteLine($"32) Last methodu sonucu son oyuncu: {sonOyuncu}");

            // LastOrDefault methodu bir koleksiyondaki son elemanı bulursa döner, bulamazsa varsayılan (default) bir değer döner,
            // koleksiyon elemanlarının tipi sayısal tip ise 0 referans tip ise null döner.
            sonKopek = kopekler.LastOrDefault();
            Console.WriteLine($"33) LastOrDefault methodu sonucu son köpek:\n{sonKopek}");

            ilkKopek = kopekler.FirstOrDefault();
            Console.WriteLine($"34) FirstOrDefault methodu sonucu ilk köpek:\n{ilkKopek}");
            #endregion

            #endregion



            #region 1) Sayı Tekillik Demo (IEnumerable Tipi ve Distinct Koleksiyon Methodu)
            SayiTekillikDemo sayiTekillikDemo = new SayiTekillikDemo();
            sayiTekillikDemo.Calistir();
            #endregion



            #region 2) İsim Bulma Demo
            IsimBulmaDemo isimBulmaDemo = new IsimBulmaDemo();
            isimBulmaDemo.Calistir();
            #endregion



            #region 3) Organizasyonlar Demo
            OrganizasyonlarDemo organizasyonlarDemo = new OrganizasyonlarDemo();
            organizasyonlarDemo.Calistir();
            #endregion
        }



        #region I) Koleksiyon Method ve Özellikleri Konusunda Konsola Yazdırmak için Overload Edilmiş Methodlar
        static void Yazdir(string ornekNo, List<int> sayilar, string listeAdi = "Sayılar")
        {
            Console.WriteLine($"\n{ornekNo} {listeAdi} Koleksiyonu Elemanları:");
            foreach (int sayi in sayilar)
            {
                Console.WriteLine(sayi);
            }
        }

        static void Yazdir(string ornekNo, List<Kopek> kopekler, string listeAdi = "Köpekler")
        {
            Console.WriteLine($"\n{ornekNo} {listeAdi} Koleksiyonu Elemanları:");
            foreach (var kopek in kopekler)
            {
                Console.WriteLine("\n" + kopek);
            }
        }

        static void Yazdir(string ornekNo, List<string> oyuncular, string listeAdi = "Oyuncular")
        {
            Console.WriteLine($"\n{ornekNo} {listeAdi} Koleksiyonu Elemanları:");
            foreach (var oyuncu in oyuncular)
            {
                Console.WriteLine(oyuncu);
            }
        }
        #endregion
    }
}