﻿namespace _20_DictionaryCollectionType.Demos
{
    public class IngilizceTurkceSozlukDemo
    {
        #region I) İngilizce Türkçe Sözlük Demo'yu Çalıştıran Method
        public void Calistir()
        {
            string giris, sonuc;

            Console.Write("İngilizce kelime giriniz (ç: çıkış) ");
            giris = Console.ReadLine();

            while (giris != "ç" && giris != "Ç")
            {
                sonuc = KelimeAra(giris);
                if (sonuc is null) // if (sonuc == null) da yazılabilir
                    Console.WriteLine("İngilizce kelime sözlükte bulunamadı.");
                else
                    Console.WriteLine($"\"{giris}\" İngilizce kelimesinin sözlükteki Türkçe karşılığı \"{sonuc}\".");

                Console.Write("İngilizce kelime giriniz (ç: çıkış) ");
                giris = Console.ReadLine();
            }
        }
        #endregion



        #region II) İngilizce Türkçe Sözlük Demo Alanları
        // sınıf altında referans değişkenleri üzerinden objeler default constructor'ları kullanılarak new'lenebilir
        Dictionary<string, string> sozluk = new Dictionary<string, string>()
        {
            { "book", "kitap" },
            { "movie", "film" },
            { "song", "şarkı" },
            { "game", "oyun" }
        };
        #endregion



        #region III) İngilizce Türkçe Sözlük Demo Davranışları
        /// <summary>
        /// Parametre olarak kullanıcıdan İngilizce bir kelime alan ve bu kelimeyi sözlükte büyük küçük harf duyarlı arayan method.
        /// </summary>
        /// <param name="ingilizceKelime"></param>
        /// <returns>string</returns>
        string KelimeAra(string ingilizceKelime)
        {
            if (sozluk.Keys.Contains(ingilizceKelime)) // eğer sözlüğün anahtarları içerisinde parametre olarak gönderilen kelime varsa,
                                                       // if (sozluk.ContainsKey(ingilizceKelime)) de yazılabilir
                return sozluk[ingilizceKelime]; // parametre olarak gönderilen kelimeye karşılık değeri dön
            return null; // eğer sözlüğün anahtarları içerisinde parametre olarak gönderilen kelime yoksa kelime bulunamadığından null dön
        }
        #endregion
    }
}
