﻿namespace _20_DictionaryCollectionType.Demos
{
    public class TurkceHarfleriIngilizceyeDonusturmeDemo
    {
        #region I) Türkçe Harfleri İngilizce'ye Dönüştürme Demo'yu Çalıştıran Method
        public void Calistir()
        {
            string giris, sonuc;

            Console.Write("\nTürkçe cümle giriniz: ");
            giris = Console.ReadLine();

            sonuc = IngilizceyeDonustur(giris);

            Console.WriteLine("Türkçe cümle: " + giris);
            Console.WriteLine("İngilizce cümle: " + sonuc);
        }
        #endregion



        #region II) Türkçe Harfleri İngilizce'ye Dönüştürme Demo Alanları
        // Neşe
        // sınıf altında referans değişkenleri üzerinden objeler default constructor'ları kullanılarak new'lenebilir
        Dictionary<string, string> harfSozlugu = new Dictionary<string, string>()
        {
            { "Ö", "O" },
            { "Ç", "C" },
            { "Ş", "S" },
            { "Ğ", "G" },
            { "Ü", "U" },
            { "ö", "o" },
            { "ç", "c" },
            { "ş", "s" },
            { "ğ", "g" },
            { "ü", "u" },
            { "İ", "I" },
            { "ı", "i" }
        };
        #endregion



        #region III) Türkçe Harfleri İngilizce'ye Dönüştürme Demo Davranışları
        /// <summary>
        /// Parametre olarak aldığı Türkçe cümle içerisindeki Türkçe harfleri İngilizce karşılıklarıyla değiştirip dönen method.
        /// </summary>
        /// <param name="turkceCumle"></param>
        /// <returns>string</returns>
        string IngilizceyeDonustur(string turkceCumle)
        {
            string ingilizceCümle = "";

            foreach (char harf in turkceCumle) // parametre olarak gönderilen Türkçe cümledeki her bir harf için
            {
                if (harfSozlugu.ContainsKey(harf.ToString())) // eğer dictionary'de döngü turundaki harfe karşılık anahtar varsa
                {
                    ingilizceCümle += harfSozlugu[harf.ToString()]; // anahtara karşılık değeri ingilizceCumle değişkenine concatenate et
                }
                else // eğer dictionary'de döngü turundaki harfe karşılık anahtar yoksa
                {
                    ingilizceCümle += harf.ToString(); // döngü turundaki harfi ingilizceCumle değişkenine concatenate et
                }
            }

            return ingilizceCümle;
        }
        #endregion
    }
}
