﻿using _20_DictionaryCollectionType.Demos;

namespace _20_DictionaryCollectionType
{
    internal class Program
    {
        static void Main(string[] args)
        {
            // Dictionary (sözlük) List gibi type safe (tip güvenli) bir koleksiyon tipidir.
            // List'ten farklı olarak tip olarak iki aynı veya farklı tipe sahip olabilir.
            // Dictionary üzerinden de pek çok koleksiyon özellik ve methodları kullanılabilir.



            #region Şehirler Dictionary
            // Dictionary<byte, string> tipinde sehirler referans değişkeni üzerinden bir obje oluşturma
            Dictionary<byte, string> sehirler = new Dictionary<byte, string>(); 

            // dictionary'e anahtar (key) ve değer (value) parametreleri üzerinden elemanlar ekleme
            sehirler.Add(6, "Ankara");
            sehirler.Add(34, "İstanbul");
            sehirler.Add(35, "İzmir");

            // dictionary elemanlarını konsola yazdırma: bir aşağıdaki şekilde anahtar (key) değer (value) çifti üzerinden
            // başında [ ve sonunda ] olacak şekilde yazdırır
            foreach (KeyValuePair<byte, string> sehir in sehirler)
            {
                Console.WriteLine(sehir);
            }

            Console.WriteLine();

            // ancak dictionary elemanlarının anahtar ve değerlerine bir aşağıdaki şekilde ayrı ayrı ulaşılabilir 
            foreach (KeyValuePair<byte, string> sehir in sehirler)
            {
                Console.WriteLine("Şehir plakası: " + sehir.Key + ", Şehir adı: " + sehir.Value);
            }

            Console.WriteLine();

            // istenirse dictionary elemanlarının anahtarları index olarak kullanılarak değerlere ulaşılabilir
            Console.WriteLine(sehirler[34]); // konsola İstanbul yazdıracaktır

            // eğer anahtara sahip eleman yoksa beklenmeyen hata (exception) fırlatır
            //Console.WriteLine(sehirler[1]); // Adana şehri dictionary'de olmadığı için beklenmeyen hata fırlatacaktır

            Console.WriteLine();

            // dictionary elemanları içerisinde herhangi bir anahtara sahip eleman olup olmadığı ContinsKey,
            // herhangi bir değere sahip eleman olup olmadığı ise ContainsValue methodlarıyla kontrol edilebilir
            if (sehirler.ContainsKey(7))
                Console.WriteLine("Antalya şehri bulundu.");
            else
                Console.WriteLine("Antalya şehri bulunamadı.");

            // Contains methodları diğer koleksiyon methodlarında olduğu gibi büyük küçük harf duyarlı (case sensitive) arama yapar
            Console.WriteLine(sehirler.ContainsValue("İzmir") ? "İzmir şehri bulundu." : "İzmir şehri bulunamadı.");

            Console.WriteLine();

            // Count özelliği üzerinden bir dictionary'deki eleman sayısına ulaşılabilir
            int sehirSayisi = sehirler.Count;
            Console.WriteLine($"Şehir sayısı: {sehirSayisi}");

            Console.WriteLine();
            #endregion



            #region Ülkeler Dictionary
            // Ülkeler Dictionary'mizi oluşturuyoruz:
            // Dictionary tipinde bir obje initialize edilirken (oluşturulurken) elemanları doldurulabilir.
            Dictionary<string, Ulke> ulkeler = new Dictionary<string, Ulke>()
            {
                {
                    // İstenirse obje default constructor üzerinden oluşturulurken özellikeri atanabilir.
                    "TR", new Ulke()
                    {
                        Adi = "Türkiye",
                        Nufusu = 84780000,
                        Yuzolcumu = 783562
                    }
                },
                { 
                    // İstenirse obje parametreli constructor üzerinden oluşturulabilir.
                    "ABD", new Ulke("Amerika Birleşik Devletleri", 331900000, 9834000)
                }
            };

            // İlk ülke bilgisini konsola yazdırıyoruz:
            string ilkUlkeAnahtari = ulkeler.Keys.FirstOrDefault(); // FirstOrDefault methodu anahtarlar koleksiyonundaki ilk elemanı döner, eleman yoksa null döner.
            Ulke ilkUlke = ulkeler[ilkUlkeAnahtari]; // İlk ülke anahtarı üzerinden ilk Ulke tipindeki objeye ulaşıyoruz.
            string ilkUlkeBilgisi = "İlk Ülke Bilgisi:\n" + // İlk ülke bilgisini ilk Ulke tipindeki obje üzerinden obje özelliklerini kullanarak string tipinde alıyoruz.
                "Kodu: " + ilkUlkeAnahtari + "\n" +
                "Adı: " + ilkUlke.Adi + "\n" +
                "Nüfusu: " + ilkUlke.Nufusu + " kişi\n" +
                "Yüzölçümü: " + ilkUlke.Yuzolcumu + " kilometrekare";
            Console.WriteLine(ilkUlkeBilgisi);

            Console.WriteLine();

            // Tüm ülke bilgilerini konsola yazdırıyoruz:
            Console.WriteLine("Tüm Ülke Bilgileri:");
            foreach (KeyValuePair<string, Ulke> ulke in ulkeler)
            {
                Console.WriteLine(ulke.Value); // Ulke class'ında ToString methodunu override ettiğimiz için parametre olarak Ulke objesini gönderip
                                               // ToString methodundan dönen string'i yazdırabiliriz, parametre olarak ulke.Value.ToString() de yazılabilir.
            }
            #endregion



            #region Demos
            IngilizceTurkceSozlukDemo ingilizceTurkceSozlukDemo = new IngilizceTurkceSozlukDemo();
            ingilizceTurkceSozlukDemo.Calistir();

            TurkceHarfleriIngilizceyeDonusturmeDemo turkceHarfleriIngilizceyeDonusturmeDemo = new TurkceHarfleriIngilizceyeDonusturmeDemo();
            turkceHarfleriIngilizceyeDonusturmeDemo.Calistir();
            #endregion
        }
    }
}