﻿using _21_ConstructorChaining.Demos.DosyaIslemleri.Models;
using System.Text;

namespace _21_ConstructorChaining.Demos.DosyaIslemleri.Bases
{
    abstract class OgrenciDosyaBase
    {
        #region Alanlar
        protected string _dosyaYolu; // Metinsel dosyanın diskteki fiziksel yolu (absolute path) alan tanımı,
                                     // alan sub class'larda kullanılabileceğinden protected tanımladık.
        #endregion



        #region Constructor
        protected OgrenciDosyaBase(string dosyaYolu) // Parametre olarak aldığı dosyaYolu'nu _dosyaYolu alanına atar,
                                                     // böylece dosya yolu hem bu class'ta hem de protected olduğundan sub class'larda kullanılabilir.
                                                     // Abstract class'larda base class constructor genelde protected tanımlanır.
        {
            _dosyaYolu = dosyaYolu;
        }
        #endregion



        #region Methodlar
        /// <summary>
        /// Metin dosyası içeriğini öğrenci listesi olarak dönen sanal method.
        /// </summary>
        /// <returns>List<Ogrenci></returns>
        public virtual List<Ogrenci> OgrencileriGetir() // Sub class'larda override edilme ihtimali olduğundan virtual tanımladık.
        {
            List<Ogrenci> ogrenciler = new List<Ogrenci>(); // Dosyadan okuyacağımız öğrenci bilgilerini öğrenci objeleri
                                                            // üzerinden dolduracağımız koleksiyon.

            Ogrenci ogrenci; // Koleksiyona dolduracağımız her bir öğrenci.

            string satir; // Metinsel dosyadaki her bir satır.



            // File class'ına alternatif olarak metinsel dosya okuma işlemleri StreamReader class'ı üzerinden de yapılabilir.

            #region 1. Yöntem:
            //StreamReader streamReader = new StreamReader(_dosyaYolu, Encoding.UTF8); // Encoding.UTF8 parametresi yazılmasa da olur ancak
            //                                                                         // eğer metinsel dosya içeriğinde Türkçe karakterler
            //                                                                         // (utf-8 karakter kümesi) varsa karakterlerde sorun
            //                                                                         // yaşanmaması için kullanılması iyi olur.

            //while ((satir = streamReader.ReadLine()) is not null) // Metinsel dosyadan satırlar okunduğu sürece döngü devam edecek.
            //{
            //    ogrenci = new Ogrenci() // Satır string'ini - karakterine göre parçalayarak ilk parçasını ad, ikinci parçasını soyad
            //                            // ve üçüncü parçasını da yaş olarak öğrenci objesi özelliklerine atıyoruz.
            //    {
            //        Adi = satir.Split('-')[0],
            //        Soyadi = satir.Split('-')[1],
            //        Yasi = int.Parse(satir.Split('-')[2])
            //    };

            //    ogrenciler.Add(ogrenci); // Öğrenci objesini koleksiyona ekliyoruz.
            //}

            //streamReader.Dispose(); // StreamReader objesi new'lenip işlemler bittikten sonra kapatılarak (close) Garbage Collector'a işinin bittiği belirtilir.
            #endregion



            #region 2. Yöntem: using Kullanımı
            // using kullanıldığında obje new'lenir, süslü parantezlerle belirlenen sınır (scope: *1 ... *2) içerisinde kullanılır ve
            // kapanış süslü parantezinde (*2) kapatılarak (close) dispose edilir yani Garbage Collector'a işinin bittiği belirtilir.
            // Dispose methodu bulunan tüm sınıflar için aynı şekilde using kullanılabilir.

            using (StreamReader streamReader = new StreamReader(_dosyaYolu, Encoding.UTF8)) // Encoding.UTF8 parametresi yazılmasa da olur ancak
                                                                                            // eğer metinsel dosya içeriğinde Türkçe karakterler
                                                                                            // (utf-8 karakter kümesi) varsa karakterlerde sorun
                                                                                            // yaşanmaması için kullanılması iyi olur.
            { // *1
                while ((satir = streamReader.ReadLine()) is not null) // Metinsel dosyadan satırlar okunduğu sürece döngü devam edecek.
                {
                    ogrenci = new Ogrenci() // Satır string'ini - karakterine göre parçalayarak ilk parçasını ad, ikinci parçasını soyad
                                            // ve üçüncü parçasını da yaş olarak öğrenci objesi özelliklerine atıyoruz.
                    {
                        Adi = satir.Split('-')[0],
                        Soyadi = satir.Split('-')[1],
                        Yasi = int.Parse(satir.Split('-')[2])
                    };

                    ogrenciler.Add(ogrenci); // Öğrenci objesini koleksiyona ekliyoruz.
                }
            } // *2
            #endregion

            

            return ogrenciler; // Koleksiyonu dönüyoruz.
        }



        /// <summary>
        /// Parametre olarak gönderilen öğrenciyi metin dosyasına satır olarak ekleyen sanal method.
        /// </summary>
        /// <param name="ogrenci"></param>
        public virtual void OgrenciEkle(Ogrenci ogrenci) // Sub class'larda override edilme ihtimali olduğundan virtual tanımladık.
        {
            string satir = $"{ogrenci.Adi}-{ogrenci.Soyadi}-{ogrenci.Yasi}"; // Metinsel dosyaya eklenecek satır.



            // File class'ına alternatif olarak metinsel dosya yazma işlemleri StreamWriter class'ı üzerinden de yapılabilir.

            #region 1. Yöntem:
            //StreamWriter streamWriter = new StreamWriter(_dosyaYolu, true, Encoding.UTF8); // StreamWriter constructor'ının ikinci parametresi olan
            //                                                                               // ve true değerini gönderdiğimiz append parametresi
            //                                                                               // dosyanın sonuna ekleme yapılacaksa true,
            //                                                                               // dosya içeriği üzerine yazılacaksa (overwrite) false gönderilir.
            //                                                                               // Encoding.UTF8 parametresi yazılmasa da olur ancak
            //                                                                               // eğer metinsel dosya içeriğinde Türkçe karakterler
            //                                                                               // (utf-8 karakter kümesi) varsa karakterlerde sorun
            //                                                                               // yaşanmaması için kullanılması iyi olur.

            //streamWriter.Write("\n" + satir); // Write methodu ile satır dosyaya yazılır.

            //streamWriter.Dispose(); // StreamWriter objesi new'lenip işlemler bittikten sonra kapatılarak (close) Garbage Collector'a işinin bittiği belirtilir.
            #endregion



            #region 2. Yöntem: using Kullanımı
            // using kullanıldığında obje new'lenir, süslü parantezlerle belirlenen sınır (scope: *1 ... *2) içerisinde kullanılır ve
            // kapanış süslü parantezinde (*2) kapatılarak (close) dispose edilir yani Garbage Collector'a işinin bittiği belirtilir.
            // Dispose methodu bulunan tüm sınıflar için aynı şekilde using kullanılabilir.

            using (StreamWriter streamWriter = new StreamWriter(_dosyaYolu, true, Encoding.UTF8)) // StreamWriter constructor'ının ikinci parametresi olan
                                                                                                  // ve true değerini gönderdiğimiz append parametresi
                                                                                                  // dosyanın sonuna ekleme yapılacaksa true,
                                                                                                  // dosya içeriği üzerine yazılacaksa (overwrite) false gönderilir.
                                                                                                  // Encoding.UTF8 parametresi yazılmasa da olur ancak
                                                                                                  // eğer metinsel dosya içeriğinde Türkçe karakterler
                                                                                                  // (utf-8 karakter kümesi) varsa karakterlerde sorun
                                                                                                  // yaşanmaması için kullanılması iyi olur.
            { // *1
                streamWriter.Write("\n" + satir); // Write methodu ile satır dosyaya yazılır.
            } // *2
            #endregion
        }
        #endregion
    }
}
