﻿using _21_ConstructorChaining.Demos.DosyaIslemleri.Models;

namespace _21_ConstructorChaining.Demos.DosyaIslemleri
{
    public class DosyaIslemleriDemo
    {
        public void Calistir()
        {
            List<Ogrenci> ogrenciler; // listeleme için öğrenci koleksiyonu

            Ogrenci yeniOgrenci; // metinsel dosyaya eklenecek öğrenci



            //OgrenciDosya ogrenciDosya = new OgrenciDosya(@"C:\TMP\ÖğrenciListesi.txt"); // ogrenciDosya instance'ı (new'lenmiş obje)
            // 1. yöntem: örnek dosyalar için bu projenin Dosyalar klasöründeki ÖğrenciListesi.txt dosyası
            // C:\TMP klasörü altına kopyalanabilir

            OgrenciDosya ogrenciDosya = new OgrenciDosya("../../../Dosyalar/ÖğrenciListesi.txt"); // ogrenciDosya instance'ı (new'lenmiş obje)
            // 2. yöntem: örnek dosya için projenin exe dosyasının bulunduğu klasörden, "/" ile ayrılarak
            // ".." ile üst klasörlere ulaşılabilir,
            // örneğin exe dosyasının bulunduğu klasör üzerinden: "C:\03_OOP\21_ConstructorChaining\bin\Debug\net8.0"
            // ".." ile "C:\03_OOP\21_ConstructorChaining\bin\Debug" klasörüne,
            // "../.." ile "C:\03_OOP\21_ConstructorChaining\bin" klasörüne,
            // "../../.." ile de "C:\03_OOP\21_ConstructorChaining" klasörüne ulaşılabilir,
            // örnek dosyamız "Dosyalar" klasöründe olduğundan "../../../Dosyalar/ÖğrenciListesi.txt" yazmalıyız



            // öğrencilerin metinsel dosyadan okunarak koleksiyonun doldurulması
            ogrenciler = ogrenciDosya.OgrencileriGetir(); 



            // öğrenci koleksiyonunun konsola yazdırılması
            Console.WriteLine("Öğrenciler:");
            foreach (Ogrenci ogrenci in ogrenciler)
            {
                Console.WriteLine($"Adı: {ogrenci.Adi}\nSoyadı: {ogrenci.Soyadi}\nYaşı: {ogrenci.Yasi}");
            }



            // yeni öğrenci bilgisinin kullanıcıdan alınması ve dosyaya eklenmesi
            yeniOgrenci = new Ogrenci();
            Console.WriteLine("\nYeni Öğrenci Girişi");
            Console.Write("Adı: ");
            yeniOgrenci.Adi = Console.ReadLine();
            Console.Write("Soyadı: ");
            yeniOgrenci.Soyadi = Console.ReadLine();
            Console.Write("Yaşı: ");
            yeniOgrenci.Yasi = Convert.ToInt32(Console.ReadLine());
            ogrenciDosya.OgrenciEkle(yeniOgrenci);



            // öğrencilerin tekrar metinsel dosyadan okunarak koleksiyonun doldurulması
            ogrenciler = ogrenciDosya.OgrencileriGetir();



            // öğrenci koleksiyonunun tekrar konsola yazdırılması
            Console.WriteLine("\nÖğrenciler:");
            foreach (Ogrenci ogrenci in ogrenciler)
            {
                Console.WriteLine($"Adı: {ogrenci.Adi}\nSoyadı: {ogrenci.Soyadi}\nYaşı: {ogrenci.Yasi}");
            }
        }
    }
}
