﻿using _22_DependencyInjection.Demos.Bases;

namespace _22_DependencyInjection.Demos
{
    public class Araba
    {
        // Constructor Injection üzerinden sürücünün arabaya enjekte edilmesi
        // ve araba davranışının enjekte edilen sürücüye göre (isim üzerinden) değişmesi

        private readonly SurucuBase _surucu; // alan tanımlandıktan sonra "Ctrl ve ." tuşlarına basılarak
                                             // Generate Constructor üzerinden parametreli constructor oluşturulabilir

        public Araba(SurucuBase surucu)
        {
            _surucu = surucu;
        }

        public void Sur()
        {
            Console.WriteLine($"Araba {_surucu.Isim} tarafından sürülüyor.");
        }
    }
}
