﻿using _25_HasArelationship._1_GokCisimleri.Entities.Bases;

namespace _25_HasArelationship._1_GokCisimleri.Entities
{
    /// <summary>
    /// GokCismiBase soyut sınıfından miras alan somut sınıf.
    /// </summary>
    public class Gezegen : GokCismiBase // is-a relationship: Gezegen bir GokCismiBase'dir
    {
        public bool YasamVarMi { get; set; }
        public List<Uydu> Uydular { get; set; } // has-a relationship: bir Gezegen objesinin içerisinde 0 veya daha çok
                                                // eleman bulunan Uydu koleksiyonu olabilir

        public Yildiz Yildiz { get; set; } // has-a relationship: bir Gezegen objesi bir Yildiz objesine sahip olabilir

        public Gezegen()
        {
            Uydular = new List<Uydu>(); // Uydular burada new'lenerek Gezegen tipinde obje new'lendiğinde
                                        // Uydular'ın null olmasının önüne geçilebilir,
                                        // içerisinde hiç bir eleman bulunmayan uydu listesi oluşturmuş olduk
        }
    }
}
