﻿using _25_HasArelationship._1_GokCisimleri.Entities.Bases;

namespace _25_HasArelationship._1_GokCisimleri.Entities
{
    /// <summary>
    /// GokCismiBase soyut sınıfından miras alan somut sınıf.
    /// </summary>
    public class Yildiz : GokCismiBase // is-a relationship: Yildiz bir GokCismiBase'dir
    {
        public float SicaklikC { get; set; }

        // 1. Yöntem:
        // read only
        //public float SicaklikF
        //{
        //    get
        //    {
        //        return SicaklikC * 1.8f + 32;
        //    }
        //}
        // 2. Yöntem:
        public float SicaklikF => SicaklikC * 1.8f + 32;

        public List<Gezegen> Gezegenler { get; set; } // has-a relationship: bir Yildiz objesinin içerisinde 0 veya daha çok
                                                      // eleman bulunan Gezegen koleksiyonu olabilir
    }
}
