﻿using _25_HasArelationship._1_GokCisimleri.Entities.Bases;
using _25_HasArelationship._1_GokCisimleri.Entities;
using _25_HasArelationship._1_GokCisimleri.Repositories;

namespace _25_HasArelationship._1_GokCisimleri
{
    public class GokCisimleriDemo
    {
        private static GokCismiRepo _repo = new GokCismiRepo();



        public void Calistir()
        {
            string giris = MenuGetir();

            while (giris != "0")
            {
                switch (giris)
                {
                    case "1":
                        TipeGoreYazdir();
                        break;
                    case "2":
                        AdaVeAdEsitligineGoreYazdir();
                        break;
                }
                giris = MenuGetir();
            }
        }



        private static string MenuGetir()
        {
            Console.WriteLine("\nİşlem seçiniz\n" +
                "0: Çıkış\n" +
                "1: Tipe göre gök cisimlerini yazdır\n" +
                "2: Ada ve ad eşitliğine göre gök cisimlerini ara");
            return Console.ReadLine();
        }



        private static void TipeGoreYazdir()
        {
            Console.WriteLine("\nGök cismi tipi seçiniz\n" +
                "1: Tümü\n" +
                "2: Yıldız\n" +
                "3: Gezegen\n" +
                "4: Uydu");
            int tip = Convert.ToInt32(Console.ReadLine());
            List<GokCismiBase> gokCisimleri = _repo.Getir((GokCismiTipi)tip);
            Console.WriteLine("\nTipe göre gök cisimleri: " + gokCisimleri.Count + " kayıt bulundu.");
            _repo.Yazdir(gokCisimleri);
        }



        private static void AdaVeAdEsitligineGoreYazdir()
        {
            Console.Write("\nGök cismi adı giriniz: ");
            string adi = Console.ReadLine();
            Console.WriteLine("Arama tipi seçiniz:\n" +
                "1: Eşit\n" +
                "2: İçeren");
            string aramaTipi = Console.ReadLine();

            // 1. yöntem:
            //List<GokCismiBase> gokCisimleri = _repo.Getir(adi, aramaTipi == "1" ? true : false);
            // 2. yöntem:
            List<GokCismiBase> gokCisimleri = _repo.Getir(adi, aramaTipi == "1");

            Console.WriteLine("\nAda ve ad eşitliğine göre gök cisimleri: " + gokCisimleri.Count + " kayıt bulundu.");
            _repo.Yazdir(gokCisimleri);
        }
    }
}
