﻿namespace _25_HasArelationship._2_BankaHesaplari.Bases
{
    /// <summary>
    /// İşlem somut sınıfının miras alacağı soyut sınıf. 
    /// </summary>
    public abstract class IslemBase 
    {
        #region Özellikler
        /// <summary>
        /// Her bir yapılan işlemdeki miktar.
        /// </summary>
        public decimal Miktar { get; } // miktar atamasını constructor üzerinden yapacağımızdan sadece değer okumak için getter oluşturuyoruz

        /// <summary>
        /// İşlemin yapıldığı tarih.
        /// </summary>
        public DateTime Tarihi { get; } // tarih atamasını constructor üzerinden yapacağımızdan sadece değer okumak için getter oluşturuyoruz

        /// <summary>
        /// İşlemin para yatırma mı para çekme mi değeri.
        /// </summary>
        public bool ParaYatirmaMi { get; } // para yatırma mı atamasını constructor üzerinden yapacağımızdan sadece değer okumak için getter oluşturuyoruz

        /// <summary>
        /// Para yatırma veya para çekme değerine göre sadece okunur açıklama.
        /// </summary>
        public string Aciklamasi => ParaYatirmaMi ? "Para yatırma işlemi." : "Para çekme işlemi.";
        #endregion



        #region Constructor
        protected IslemBase(decimal miktar, bool paraYatirmaMi) // class abstract olduğu için constructor'ı protected tanımlıyoruz
        {
            Miktar = miktar;
            ParaYatirmaMi = paraYatirmaMi;
            Tarihi = DateTime.Now; // işlemin oluşturulduğu tarih ve saati tarihe atıyoruz
        }
        #endregion
    }
}
