﻿using _25_HasArelationship._2_BankaHesaplari.Enums;

namespace _25_HasArelationship._2_BankaHesaplari.Config
{
    /// <summary>
    /// Banka hesapları uygulaması konfigürasyonu ile ilgili tüm uygulama için ortak paylaşılan statik sınıf.
    /// </summary>
    public static class HesapConfig
    {
        /// <summary>
        /// Hesapların alacağı ilk Id değeri, aldıktan sonra 1 arttırılır.
        /// </summary>
        public static int Id { get; set; } = 1;

        /// <summary>
        /// Geçersiz kullanıcı girişi mesajını döner.
        /// </summary>
        public static string GecersizGiris => "Geçersiz giriş!";

        /// <summary>
        /// Hesap eklemenin başarılı sonuç mesajını döner.
        /// </summary>
        public static string HesapEklendi => "Hesap başarıyla eklendi.";

        /// <summary>
        /// Hesap silmenin başarılı sonuç mesajını döner.
        /// </summary>
        public static string HesapSilindi => "Hesap başarıyla silindi.";

        /// <summary>
        /// Hesap listesinde hesap yoksa bulunamadı mesajını döner.
        /// </summary>
        public static string HesapBulunamadi => "Hesap bulunamadı.";

        /// <summary>
        /// Bireysel hesap faiz oranı.
        /// </summary>
        public static decimal BireyselFaizOrani => 0.1m;

        /// <summary>
        /// Kurumsal hesap faiz oranı.
        /// </summary>
        public static decimal KurumsalFaizOrani => 0.2M;

        /// <summary>
        /// IslemSonucu enum'ı üzerinden islemSonucu parametresine karşılık string dönen method.
        /// </summary>
        /// <param name="islemSonucu"></param>
        /// <returns></returns>
        public static string IslemSonucuGetir(IslemSonucu islemSonucu) => islemSonucu == IslemSonucu.Basarili ?
            "İşlem başarılı." : islemSonucu == IslemSonucu.NegatifMiktar ?
            "Miktar pozitif bir sayı girilmelidir!" :
            "İşlem sonucu bakiye eksiye düşmektedir!";
    }
}
