﻿using _26_RecursiveMethods.Demos.TasKagitMakas.Models.Bases;
using _26_RecursiveMethods.Demos.TasKagitMakas.Services.Bases;

namespace _26_RecursiveMethods.Demos.TasKagitMakas.Services
{
    /// <summary>
    /// Taş Kağıt Makas Oyunu işlemlerini gerçekleştiren, ITasKagitMakasService interface'ini implemente eden
    /// ve oyuncunun enjekte edildiği servis class'ı.
    /// </summary>
    public class TasKagitMakasService : ITasKagitMakasService
    {
        #region Fields
        private readonly OyuncuBase _oyuncu; // has-a relationship: TasKagitMakasService tipindeki obje OyuncuBase tipindeki objeye sahiptir

        /// <summary>
        /// 1 (dahil) ile 3 (dahil) aralığında rastgele sayı üretecek referans.
        /// </summary>
        Random _rastgele;

        /// <summary>
        /// k: kağıt, m: makas, t: taş anahtar değer çiftlerine sahip sözlük.
        /// </summary>
        Dictionary<char, string> _hareketler;
        #endregion



        #region Constructor
        public TasKagitMakasService(OyuncuBase oyuncu) // dependency injection (constructor injection),
                                                       // TasKagitMakasService objesini new'lerken içerisine dışarıdan
                                                       // new'lenmiş OyuncuBase tipindeki objeyi enjekte ediyoruz
        {
            _oyuncu = oyuncu;
            _rastgele = new Random();
            _hareketler = new Dictionary<char, string>()
            {
                { 'k', "Kağıt" },
                { 'm', "Makas" },
                { 't', "Taş" }
            };
        }
        #endregion



        #region Method Implementations
        /// <summary>
        /// Oyuncu kazanma sayısını sıfırlar.
        /// </summary>
        public void YeniOyunaBasla()
        {
            _oyuncu.KazanmaSayisi = 0;
        }

        /// <summary>
        /// Bilgisayar için rastgele olarak taş (t), kağıt (k) veya makas (m) hareketi, oyuncu için de gönderilen hareket parametresi 
        /// üzerinden oyunu oynatır ve kazananı geri döner.
        /// </summary>
        /// <returns>string</returns>
        public string Oyna(char oyuncuHareketi, string sonuc = null)
        {
            int rastgeleSayi = _rastgele.Next(1, 4);
            char bilgisayarHareketi = rastgeleSayi == 1 ? 'k' : rastgeleSayi == 2 ? 'm' : 't';
            if (bilgisayarHareketi == oyuncuHareketi) // eğer bilgisayar ile oyuncu hareketleri aynıysa tekrar recursive olarak
                                                      // Oyna methodu çağrılır ve berabere sonucunun gelmemesi sağlanır
            {
                sonuc = Oyna(oyuncuHareketi, sonuc);
            }
            else
            {
                sonuc = "\nBilgisayar: " + _hareketler[bilgisayarHareketi] + "\nOyuncu: " + _hareketler[oyuncuHareketi];
                if (bilgisayarHareketi == 'k')
                {
                    if (oyuncuHareketi == 'm')
                    {
                        sonuc += "\n\"" + _oyuncu.Rumuzu + "\" kazandı.\nKazanma sayısı: " + ++_oyuncu.KazanmaSayisi;
                    }
                    else
                    {
                        sonuc += "\nBilgisayar kazandı.";
                    }
                }
                else if (bilgisayarHareketi == 'm')
                {
                    if (oyuncuHareketi == 't')
                    {
                        sonuc += "\n\"" + _oyuncu.Rumuzu + "\" kazandı.\nKazanma sayısı: " + ++_oyuncu.KazanmaSayisi;
                    }
                    else
                    {
                        sonuc += "\nBilgisayar kazandı.";
                    }
                }
                else
                {
                    if (oyuncuHareketi == 'k')
                    {
                        sonuc += "\n\"" + _oyuncu.Rumuzu + "\" kazandı.\nKazanma sayısı: " + ++_oyuncu.KazanmaSayisi;
                    }
                    else
                    {
                        sonuc += "\nBilgisayar kazandı.";
                    }
                }
            }
            return sonuc;
        }
        #endregion
    }        
}
