﻿using _26_RecursiveMethods.Demos.TasKagitMakas.Models;
using _26_RecursiveMethods.Demos.TasKagitMakas.Models.Bases;
using _26_RecursiveMethods.Demos.TasKagitMakas.Services;
using _26_RecursiveMethods.Demos.TasKagitMakas.Services.Bases;

namespace _26_RecursiveMethods.Demos.TasKagitMakas
{
    public class TasKagitMakasDemo
    {
        #region Methods
        public void Calistir()
        {
            OyuncuBase oyuncu = OyuncuOlustur();
            ITasKagitMakasService servis = new TasKagitMakasService(oyuncu);

            char giris = MenuGetir();
            while (giris != 'ç')
            {
                if (giris != 't' && giris != 'k' && giris != 'm' && giris != 'y')
                {
                    Console.WriteLine("\nGeçersiz giriş!");
                }
                else
                {
                    if (giris == 'y')
                    {
                        servis.YeniOyunaBasla();
                        Console.WriteLine("\nYeni oyun başladı.");
                    }
                    else
                    {
                        Console.WriteLine(servis.Oyna(giris));
                    }
                }
                giris = MenuGetir();
            }
        }

        OyuncuBase OyuncuOlustur()
        {
            OyuncuBase oyuncu;
            Console.Write("Oyuncu rumuzu giriniz: ");
            string rumuz = Console.ReadLine().Trim();
            oyuncu = new Oyuncu()
            {
                Rumuzu = rumuz
            };
            return oyuncu;
        }

        char MenuGetir()
        {
            Console.Write("Hareket seçiniz (t: taş, k: kağıt, m: makas, ç: çıkış, y: yeni oyun): ");
            return Console.ReadLine().Trim().ToLower()[0];
        }
        #endregion
    }
}
