﻿using _27_DemoKopeklerimConsoleApp.Data;
using _27_DemoKopeklerimConsoleApp.Entities;
using _27_DemoKopeklerimConsoleApp.Entities.Bases;
using _27_DemoKopeklerimConsoleApp.Repositories;
using System.Globalization;

namespace _27_DemoKopeklerimConsoleApp
{
    internal class Program
    {
        static KopekRepo _kopekRepo;
        static IrkRepo _irkRepo;

        static void Main(string[] args)
        {
            _irkRepo = new IrkRepo();
            _kopekRepo = new KopekRepo();

            string giris = MenuGetir();

            while (giris != "0")
            {
                switch (giris)
                {
                    case "1":
                        KopekleriListele();
                        break;
                    case "2":
                        AdaGoreKopekleriListele();
                        break;
                    case "3":
                        IdyeGoreKopegiGoster();
                        break;
                    case "4":
                        KopekEkle2();
                        break;
                    case "5":
                        KopekGuncelle2();
                        break;
                    case "6":
                        KopekSil();
                        break;
                    default:
                        Console.WriteLine("Geçersiz işlem!");
                        break;
                }
                giris = MenuGetir();
            }
        }

        static string MenuGetir()
        {
            Console.WriteLine("\nİşlem seçiniz\n" +
                "0: Çıkış\n" +
                "1: Tüm köpeklerimi listele\n" +
                "2: Ada göre köpeklerimi listele\n" +
                "3: ID'ye göre köpeğimi göster\n" +
                "4: Köpek ekle\n" +
                "5: Köpek güncelle\n" +
                "6: Köpek sil");
            return Console.ReadLine().Trim();
        }

        static void Yazdir(Kopek kopek)
        {
            string kopekText;
            string irkText;
            kopekText = $"\nKöpeğim\n" +
                $"ID: {kopek.Id}\n" +
                $"Adı: {kopek.Adi}\n" +
                $"Doğum Tarihi: {kopek.DogumTarihi.ToString("dd.MM.yyyy HH:mm:ss")}\n" +
                $"Cinsiyeti: {(kopek.ErkekMi ? "Erkek" : "Dişi")}\n" +
                $"Boyu: {kopek.Boyu.ToString("N1", new CultureInfo("tr-TR"))} cm\n" +
                $"Kilosu: {kopek.Kilosu.ToString("N1", new CultureInfo("tr-TR"))} kg";
            irkText = $"\nIrk\n" +
                $"Adı: {kopek.Irki.Adi}\n" +
                $"Ülkesi: {kopek.Irki.Ulkesi}";
            Console.WriteLine(kopekText + irkText);
        }

        static void Yazdir(List<Kopek> kopekler)
        {
            Console.WriteLine("\n" + Veriler.KayitSayisiMesajiGetir(kopekler.Count));
            foreach (Kopek kopek in kopekler)
            {
                Yazdir(kopek);
            }
        }

        static void Yazdir(List<Irk> irklar)
        {
            string irkText;
            foreach (Irk irk in irklar)
            {
                irkText = $"\nIrk\n" +
                $"ID: {irk.Id}\n" +
                $"Adı: {irk.Adi}\n" +
                $"Ülkesi: {irk.Ulkesi}";
                Console.WriteLine(irkText);
            }
        }

        static void KopekleriListele()
        {
            Yazdir(_kopekRepo.KopekleriGetir());
        }

        static void AdaGoreKopekleriListele()
        {
            Console.Write("\nKöpek Adı: ");
            string adi = Console.ReadLine().Trim();
            Yazdir(_kopekRepo.KopekleriGetir(adi));
        }

        static void IdyeGoreKopegiGoster()
        {
            try
            {
                Console.Write("\nKöpek ID: ");
                int kopekId = Convert.ToInt32(Console.ReadLine());
                Kayit kopek = _kopekRepo.KayitGetir(kopekId);
                if (kopek != null)
                    Yazdir((Kopek)kopek);
                else
                    Console.WriteLine(Veriler.KayitBulunamadiMesaji);
            }
            catch
            {
                Console.WriteLine(Veriler.HataMesaji);
            }
        }

        static Kopek KopekOlustur(int id = 0)
        {
            if (id > 0)
            {
                Kayit mevcutKopek = _kopekRepo.KayitGetir(id);
                if (mevcutKopek == null)
                {
                    Console.WriteLine(Veriler.KayitBulunamadiMesaji);
                    return null;
                }
            }
            Console.Write("\nAdı: ");
            string adi = Console.ReadLine();
            Console.Write("Doğum Tarihi (gün.ay.yıl saat:dakika:saniye): ");
            DateTime dogumTarihi = DateTime.Parse(Console.ReadLine(), new CultureInfo("tr-TR"));
            Console.Write("Cinsiyeti (1: dişi, 2: erkek): ");
            string cinsiyeti = Console.ReadLine();
            if (!(cinsiyeti == "1" || cinsiyeti == "2"))
            {
                Console.WriteLine("Geçersiz cinsiyet!");
                return null;
            }
            bool erkekMi = cinsiyeti == "1" ? false : true;
            Console.Write("Boyu (cm): ");
            double boyu = Convert.ToDouble(Console.ReadLine(), new CultureInfo("tr-TR"));
            Console.Write("Kilosu (kg): ");
            double kilosu = double.Parse(Console.ReadLine(), new CultureInfo("tr-TR"));
            Yazdir(_irkRepo.IrklariGetir());
            Console.Write("Irk ID: ");
            int irkId = int.Parse(Console.ReadLine());
            Kayit irk = _irkRepo.KayitGetir(irkId);
            if (irk == null)
            {
                Console.WriteLine(Veriler.KayitBulunamadiMesaji);
                return null;
            }
            return new Kopek()
            {
                Id = id,
                Adi = adi.Trim(),
                DogumTarihi = dogumTarihi,
                ErkekMi = erkekMi,
                Boyu = boyu,
                Kilosu = kilosu,
                Irki = irk as Irk
            };
        }

        static void KopekEkle1()
        {
            try
            {
                Console.WriteLine("\nKöpek Ekleme");
                Console.Write("\nAdı: ");
                string adi = Console.ReadLine();
                Console.Write("Doğum Tarihi (gün.ay.yıl saat:dakika:saniye): ");
                DateTime dogumTarihi = DateTime.Parse(Console.ReadLine(), new CultureInfo("tr-TR"));
                Console.Write("Cinsiyeti (1: dişi, 2: erkek): ");
                string cinsiyeti = Console.ReadLine();
                if (!(cinsiyeti == "1" || cinsiyeti == "2"))
                {
                    Console.WriteLine("Geçersiz cinsiyet!");
                }
                else
                {
                    bool erkekMi = cinsiyeti == "1" ? false : true;
                    Console.Write("Boyu (cm): ");
                    double boyu = Convert.ToDouble(Console.ReadLine(), new CultureInfo("tr-TR"));
                    Console.Write("Kilosu (kg): ");
                    double kilosu = double.Parse(Console.ReadLine(), new CultureInfo("tr-TR"));
                    Yazdir(_irkRepo.IrklariGetir());
                    Console.Write("Irk ID: ");
                    int irkId = int.Parse(Console.ReadLine());
                    Console.WriteLine(_kopekRepo.KopekEkle(adi, dogumTarihi, erkekMi, irkId, boyu, kilosu));
                }
            }
            catch
            {
                Console.WriteLine(Veriler.HataMesaji);
            }
        }

        static void KopekEkle2()
        {
            try
            {
                Console.WriteLine("\nKöpek Ekleme");
                Kopek kopek = KopekOlustur();
                Console.WriteLine(_kopekRepo.KopekEkle(kopek));
            }
            catch
            {
                Console.WriteLine(Veriler.HataMesaji);
            }
        }

        static void KopekGuncelle1()
        {
            try
            {
                Console.WriteLine("\nKöpek Güncelleme");
                Yazdir(_kopekRepo.KopekleriGetir());
                Console.Write("\nKöpek ID: ");
                int kopekId = int.Parse(Console.ReadLine());
                Kayit mevcutKopek = _kopekRepo.KayitGetir(kopekId);
                if (mevcutKopek == null)
                {
                    Console.WriteLine(Veriler.KayitBulunamadiMesaji);
                }
                else
                {
                    Console.Write("\nAdı: ");
                    string adi = Console.ReadLine();
                    Console.Write("Doğum Tarihi (gün.ay.yıl saat:dakika:saniye): ");
                    DateTime dogumTarihi = DateTime.Parse(Console.ReadLine(), new CultureInfo("tr-TR"));
                    Console.Write("Cinsiyeti (1: dişi, 2: erkek): ");
                    string cinsiyeti = Console.ReadLine();
                    if (!(cinsiyeti == "1" || cinsiyeti == "2"))
                    {
                        Console.WriteLine("Geçersiz cinsiyet!");
                    }
                    else
                    {
                        bool erkekMi = cinsiyeti == "1" ? false : true;
                        Console.Write("Boyu (cm): ");
                        double boyu = Convert.ToDouble(Console.ReadLine(), new CultureInfo("tr-TR"));
                        Console.Write("Kilosu (kg): ");
                        double kilosu = double.Parse(Console.ReadLine(), new CultureInfo("tr-TR"));
                        Yazdir(_irkRepo.IrklariGetir());
                        Console.Write("Irk ID: ");
                        int irkId = int.Parse(Console.ReadLine());
                        Console.WriteLine(_kopekRepo.KopekGuncelle(kopekId, adi, dogumTarihi, erkekMi, irkId, boyu, kilosu));
                    }
                }
            }
            catch
            {
                Console.WriteLine(Veriler.HataMesaji);
            }
        }

        static void KopekGuncelle2()
        {
            try
            {
                Console.WriteLine("\nKöpek Güncelleme");
                Yazdir(_kopekRepo.KopekleriGetir());
                Console.Write("\nKöpek ID: ");
                int kopekId = int.Parse(Console.ReadLine());
                Kopek kopek = KopekOlustur(kopekId);
                Console.WriteLine(_kopekRepo.KopekGuncelle(kopek));
            }
            catch
            {
                Console.WriteLine(Veriler.HataMesaji);
            }
        }

        static void KopekSil()
        {
            try
            {
                Console.WriteLine("\nKöpek Silme");
                Yazdir(_kopekRepo.KopekleriGetir());
                Console.Write("\nKöpek ID: ");
                int kopekId = Convert.ToInt32(Console.ReadLine());
                Console.WriteLine(_kopekRepo.KopekSil(kopekId));
            }
            catch
            {
                Console.WriteLine(Veriler.HataMesaji);
            }
        }
    }
}