﻿using CORE.APP.Models;
using CORE.APP.Services;
using Locations.APP.Domain;
using MediatR;
using Microsoft.EntityFrameworkCore;

namespace Locations.APP.Features.Countries
{
    public class CountryDeleteRequest : Request, IRequest<CommandResponse>
    {
    }

    public class CityDeleteHandler : Service<Country>, IRequestHandler<CountryDeleteRequest, CommandResponse>
    {
        protected override IQueryable<Country> DbSet()
        {
            return base.DbSet().Include(country => country.Cities);
        }

        public CityDeleteHandler(DbContext db) : base(db)
        {
        }

        public async Task<CommandResponse> Handle(CountryDeleteRequest request, CancellationToken cancellationToken)
        {
            // isNoTracking is false for being tracked by EF Core to delete the entity
            var entity = await DbSet().SingleOrDefaultAsync(country => country.Id == request.Id, cancellationToken);
            if (entity is null)
                return Error("Country not found!");

            // Way 1: check relational cities
            //if (entity.Cities.Any())
            //    return Error("Country can't be deleted because it has relational cities!");
            // Way 2: delete relational cities (not recommended)
            Delete(entity.Cities);

            await DeleteAsync(entity, cancellationToken);

            return Success("Country deleted successfully.", entity.Id);
        }
    }
}
