﻿using CORE.APP.Models;
using CORE.APP.Services;
using Locations.APP.Domain;
using Locations.APP.Features.Cities;
using MediatR;
using Microsoft.EntityFrameworkCore;

namespace Locations.APP.Features.Countries
{
    public class CountryQueryRequest : Request, IRequest<IQueryable<CountryQueryResponse>>
    {
    }

    public class CountryQueryResponse : Response
    {
        public string CountryName { get; set; }
        public List<CityQueryResponse> Cities { get; set; }
    }

    public class CountryQueryHandler : Service<Country>, IRequestHandler<CountryQueryRequest, IQueryable<CountryQueryResponse>>
    {
        protected override IQueryable<Country> DbSet()
        {
            return base.DbSet().Include(country => country.Cities).OrderBy(country => country.CountryName);
        }

        public CountryQueryHandler(DbContext db) : base(db)
        {
        }

        public Task<IQueryable<CountryQueryResponse>> Handle(CountryQueryRequest request, CancellationToken cancellationToken)
        {
            var query = DbSet().Select(country => new CountryQueryResponse
            {
                Id = country.Id,
                CountryName = country.CountryName,
                Cities = country.Cities.OrderBy(city => city.CityName).Select(city => new CityQueryResponse
                {
                    Id = city.Id,
                    CityName = city.CityName
                }).ToList()
            });

            return Task.FromResult(query);
        }
    }
}
